/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.entities.behaviour.plants;

import com.badlogic.gdx.ai.msg.MessageDispatcher;
import technology.rocketjump.undermount.entities.components.BehaviourComponent;
import technology.rocketjump.undermount.entities.components.EntityComponent;
import technology.rocketjump.undermount.entities.components.SteeringComponent;
import technology.rocketjump.undermount.entities.model.Entity;
import technology.rocketjump.undermount.entities.model.physical.plant.PlantEntityAttributes;
import technology.rocketjump.undermount.environment.model.Season;
import technology.rocketjump.undermount.gamecontext.GameContext;
import technology.rocketjump.undermount.mapping.model.TiledMap;

public class TreeBehaviour
implements BehaviourComponent {
    private MessageDispatcher messageDispatcher;
    private Entity parentEntity;
    private Double lastUpdateGameTime;
    private final double AVG_TIME_TO_SHED_LEAVES_IN_GAME_HOURS = 84.0;

    @Override
    public EntityComponent clone(MessageDispatcher messageDispatcher, TiledMap tiledMap) {
        return new TreeBehaviour();
    }

    @Override
    public void init(Entity parentEntity, MessageDispatcher messageDispatcher, TiledMap areaMap) {
        this.messageDispatcher = messageDispatcher;
        this.parentEntity = parentEntity;
    }

    @Override
    public void update(float deltaTime, TiledMap areaMap) {
    }

    @Override
    public void infrequentUpdate(GameContext gameContext) {
        if (this.lastUpdateGameTime == null) {
            this.lastUpdateGameTime = gameContext.getGameClock().getCurrentGameTime();
        }
        PlantEntityAttributes attributes = (PlantEntityAttributes)this.parentEntity.getPhysicalEntityComponent().getAttributes();
        float leafColorChangeAmount = attributes.getLeafColorChangeAmount();
        Season currentSeason = gameContext.getAreaMap().getEnvironment().getCurrentSeason();
        if (!attributes.getSpecies().isEvergreen()) {
            double currentGameTime = gameContext.getGameClock().getCurrentGameTime();
            double elapsedGameHours = currentGameTime - this.lastUpdateGameTime;
            this.lastUpdateGameTime = currentGameTime;
            if (currentSeason.equals((Object)Season.AUTUMN) || currentSeason.equals((Object)Season.WINTER)) {
                if (leafColorChangeAmount >= 0.0f) {
                    leafColorChangeAmount = (float)((double)leafColorChangeAmount + elapsedGameHours * (double)attributes.getLeafColorChangeRate() / 84.0);
                }
            } else {
                leafColorChangeAmount = leafColorChangeAmount < 0.0f ? (float)((double)leafColorChangeAmount + elapsedGameHours * (double)attributes.getLeafColorChangeRate() / 84.0) : 0.0f;
            }
            if (leafColorChangeAmount > attributes.getLeafDropAmount()) {
                leafColorChangeAmount = -0.1f;
            }
            attributes.setLeafColorChangeAmount(leafColorChangeAmount);
        }
    }

    @Override
    public SteeringComponent getSteeringComponent() {
        return null;
    }

    @Override
    public boolean isUpdateEveryFrame() {
        return false;
    }

    @Override
    public boolean isUpdateInfrequently() {
        return true;
    }

    @Override
    public boolean isJobAssignable() {
        return false;
    }
}

